/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: HexEdit.cpp 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Edit Control supporting hexadecimal entries

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HexEdit.cpp
///   Edit Control supporting hexadecimal entries
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "HexEdit.h"
#include ".\hexedit.h"

IMPLEMENT_DYNAMIC(CHexEdit, CEdit)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
/////////////////////////////////////////////////////////////////////////////
CHexEdit::CHexEdit()
: m_fDisplayHex(true)
, m_fForceHexConversion(false)
, m_ulHexWidth(8)
, m_ulValue(0)
, m_pulValue(NULL)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CHexEdit::~CHexEdit()
{
}


BEGIN_MESSAGE_MAP(CHexEdit, CEdit)
  ON_CONTROL_REFLECT(EN_CHANGE, OnEnChange)
  ON_CONTROL_REFLECT(EN_KILLFOCUS, OnEnKillfocus)
END_MESSAGE_MAP()

void CHexEdit::OnEnChange()
{
  CString csTemp;
  GetWindowText(csTemp);

  //TODO: Check for valid characters
  //      Xx is only allowed at 2nd position, when 0 is prepended
  //      0-9, A-F allowed on every other position
  
}

/////////////////////////////////////////////////////////////////////////////
/// Edit control editing end event
/////////////////////////////////////////////////////////////////////////////
void CHexEdit::OnEnKillfocus()
{
  //Validate Entry
  int iBase = 10;

  CString csText;
  GetWindowText(csText);

  //check if we have a prepending 0x to force hex conversion
  if( (csText.GetLength() >= 2) &&
      (csText.Left(2).CompareNoCase(_T("0x")) == 0) )      
  {
    csText = csText.Mid(2);
    iBase  = 16;

  } else if(csText.FindOneOf(_T("ABCDEFabcdef")) != -1)
  {
    //the string contains hex chars, so we must convert it 
    iBase = 16;
  } else if(m_fForceHexConversion)
  {
    iBase  = 16;
  }

  TCHAR* pszStop = NULL;

  unsigned long ulValue = _tcstoul(csText, &pszStop, iBase);

  //TODO: Validity Checks, like range, etc.

  SetValue( ulValue);
}

/////////////////////////////////////////////////////////////////////////////
/// Update the value of the control
/////////////////////////////////////////////////////////////////////////////
void CHexEdit::Update(void)
{
  if(m_fDisplayHex)
  {
    CString csFormat, csText;
    csFormat.Format(_T("0x%%0%uX"), m_ulHexWidth);
    csText.Format(csFormat, m_ulValue);
    SetWindowText(csText);
  }
}
